﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class MenuDataExtended : SppMenuData {
	public UIHandler uiHandler;

	public override void PopulateUI() {

		if (showOnlineData) {
			items = onlineItems;
		} else {
			items = offlineItems;
		}
		if (gridLayoutGroup != null && referenceButton != null) {

			for (int i = 0; i < items.Length; i++) {
				Button newButton = Instantiate(referenceButton);
				newButton.name = "Button" + i.ToString ("d6");
				newButton.gameObject.SetActive (true);
				Text[] txts = newButton.GetComponentsInChildren<Text> ();
				txts [0].text = items [i].name;
				newButton.onClick.AddListener (delegate {
					OnClick (newButton);

				});
				newButton.transform.SetParent (gridLayoutGroup.transform);
				newButton.transform.localScale = Vector3.one;
			}	
			rtContent.sizeDelta = new Vector3 (rtContent.sizeDelta.x, items.Length * referenceButton.GetComponent<RectTransform>().sizeDelta.y);
		}	
	}	

	public override void OnClick(Button btn) {
		string name = btn.name;
		int idx = System.Convert.ToInt32 (name.Substring (name.Length - 6, 6));
		if (modelLoader != null) {
			if (showOnlineData) {
				uiHandler.ShowViewerUI ();
				modelLoader.Load (items [idx].url, "/");
			} else {
				uiHandler.ShowViewerUI ();
				modelLoader.LoadOffline (items [idx].url, "/");
			}	
		}	
	}

}
